/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.conndata;

import java.io.Serializable;

public class ServerInfo
implements Serializable {
    private static final long serialVersionUID = -1959212065645790730L;
    private String ipAddress = "";
    private int port = 0;
    private String isoCountryCode = "";
    private String isoSubdivisionCode = "";

    public ServerInfo(String ipAddress, int port) {
        this(ipAddress, port, "", "");
    }

    public ServerInfo(String ipAddress, int port, String countryCode, String subdivCode) {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Null IP address specified");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Out of range port specified: " + port);
        }
        if (countryCode == null) {
            throw new IllegalArgumentException("Null ISO country code specified");
        }
        if (!countryCode.equals("") && countryCode.length() != 2) {
            throw new IllegalArgumentException("Non 2 character ISO country code specified");
        }
        if (subdivCode == null) {
            throw new IllegalArgumentException("Null ISO subdivision code specified");
        }
        if (!subdivCode.equals("") && subdivCode.length() > 3) {
            throw new IllegalArgumentException("Non 1-3 character ISO country code specified");
        }
        this.ipAddress = ipAddress;
        this.port = port;
        this.isoCountryCode = countryCode;
        this.isoSubdivisionCode = subdivCode;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public String getIsoCountryCode() {
        return this.isoCountryCode;
    }

    public String getIsoSubdivisionCode() {
        return this.isoSubdivisionCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ServerInfo: ipAddress=" + this.ipAddress + ", ");
        sb.append("port=" + this.port + ", ");
        sb.append("isoCtryCode=" + this.isoCountryCode + ", ");
        sb.append("isoSubdivCode=" + this.isoSubdivisionCode + "]");
        return sb.toString();
    }
}

